package de.bebagoe.figuren;

public class Rechteck extends Figur {
	protected double breite, hoehe;
	
	public Rechteck(double x, double y, double b, double h) {
        if (b < 0 || h < 0)
            throw new IllegalArgumentException("Flächeninhalt negativ");
        breite = b;
        hoehe = h;
		super(x, y);
	}
	
	public Rechteck() {
        breite = 100.0;
        hoehe = 50.0;
        super();
    }

    public double getBreite() { return breite; }
    public double getHoehe() { return hoehe; }

	@Override
	public void wo() {
		super.wo();
		System.out.println("Unten rechts: (" + (xpos+breite) +
						", " + (ypos+hoehe) + ")");
	}

	@Override
	public double meldeInhalt() {
		return breite * hoehe;
	}
}

